@REM Dokumentation: http://www.prodat-sql.de/redmine/projects/prodat-v-x/wiki/Skripte_%28CMD%29
@PROMPT @@$G$S
@CHCP 1252 > NUL
@SETLOCAL ENABLEDELAYEDEXPANSION

@ECHO.
@ECHO ProdatSRV (de)installieren, setupen, staten, stoppen...
@ECHO.

@REM Administratortest (Hoch=S-1-16-12288 oder Mittel=S-1-16-8192)
@IF /i "%1" == "-admin"   GOTO Admin
  @WHOAMI /groups | FIND "S-1-16-12288" > NUL
  @IF NOT ERRORLEVEL 1   GOTO Admin
  ::@ECHO Admin-Prfung berspringen = Name und Password leer lassen
  ::@SET /P AdminName=Name des Admin-Kontos eingeben (nichts = "Administrator"): 
  ::@CALL :Trim AdminName %AdminName% 
  ::@IF NOT DEFINED AdminName   SET AdminName=Administrator
  ::RUNAS /user:%COMPUTERNAME%\%AdminName% "\"%~dpf0\" -admin"
  ::@IF ERRORLEVEL 1 ( ECHO. && ECHO ERROR-CODE %ERRORLEVEL% && ECHO. ) ELSE ( EXIT )
  REM Irgendwie scheint "Explorer: Ausfhren als" anders zu arbeiten, als RUNAS.
  REM Nach RUNAS gibt es irgendwo eine Exception in der ProdatSRV.exe
  @ECHO.
  @ECHO Batch manuell als Admin starten  -^>  Kontextmen : Als Admnistrator ausfhren
  @ECHO.
  PAUSE
  EXIT /B 1
:Admin

:Wiederholen
@ECHO.
@ECHO.
@ECHO  s = Setup         Setup-Dialog ffnen (ohne stoppen und starten)
@ECHO  i = Install       Service installieren und starten
@ECHO  u = Uninstall     Service stoppen und deinstallieren
@ECHO. 
@ECHO  a = Start         Service starten
@ECHO  o = Stop          Service stoppen
@ECHO  r = Restart       Service stoppen, warten und wieder starten
@ECHO.
@ECHO  d = Debug         Als Fenster-Anwendung starten (fr Debugging)
@ECHO.
@ECHO  x = Abbruch       Script beenden
@ECHO.
@SET Operation=
@CHOICE /c siuaordx /n
@ECHO %errorlevel%
@IF %errorlevel% EQU 255 EXIT /B
@IF %errorlevel% EQU 0   EXIT /B
@IF %errorlevel% EQU 1   SET Operation=s
@IF %errorlevel% EQU 2   SET Operation=i
@IF %errorlevel% EQU 3   SET Operation=u
@IF %errorlevel% EQU 4   SET Operation=a
@IF %errorlevel% EQU 5   SET Operation=o
@IF %errorlevel% EQU 6   SET Operation=r
@IF %errorlevel% EQU 7   SET Operation=d
@IF %errorlevel% EQU 8   EXIT /B
@IF "%Operation%" == ""  GOTO Wiederholen

@ECHO.
@ECHO Mandant: keine Leerzeichen / wird fr Optionen (Name der INI) genutzt
@ECHO          nur A-Z, 0-9, _ und optional auch -
@ECHO.
@SET "istate=            [run]"
  @SC queryex type= service state= inactive | FIND /i "SERVICE_NAME: ProdatSRV_Service" > NUL
  @IF NOT ERRORLEVEL 1  SET "istate=   inactive      "
  @SC queryex type= service state= all      | FIND /i "SERVICE_NAME: ProdatSRV_Service" > NUL
  @IF ERRORLEVEL 1      SET "istate=    not installed"
  @ECHO    %istate% [DEFAULT]
@FOR /f "tokens=*" %%F IN ('DIR /B "%~dp0Administration\ProdatSRV_*.ini"') DO @(
  SET iname=%%F
  SET iname=!iname:~10,-4!
  SET "istate=            [run]"
  SC queryex type= service state= inactive | FIND /i "SERVICE_NAME: ProdatSRV_!iname:-=_!_Service" > NUL
  IF NOT ERRORLEVEL 1  SET "istate=   inactive      "
  SC queryex type= service state= all      | FIND /i "SERVICE_NAME: ProdatSRV_!iname:-=_!_Service" > NUL
  IF ERRORLEVEL 1      SET "istate=    not installed"
  ECHO    !istate! !iname!
)
@FOR /f "tokens=*" %%F IN ('SC queryex type^= service state^= all ^| FIND /i "SERVICE_NAME: ProdatSRV_"') DO @(
  SET iname=%%F
  SET iname=!iname:~26,-8!
  IF NOT EXIST "%~dp0Administration\ProdatSRV_!iname!.ini" (
    SET "istate= other path [run]"
    SC queryex type= service state= inactive | FIND /i "SERVICE_NAME: ProdatSRV_!iname:-=_!_Service" > NUL
    IF NOT ERRORLEVEL 1  SET "istate= other path      "
    ECHO    !istate! !iname!
  )
)

@ECHO.
@SET Mandant=
@SET /P Mandant=Name des Mandant eingeben (Default=leer): 
@CALL :Trim Mandant %Mandant% 
@SET ProdatSrvIni=Administration\ProdatSRV.ini
@IF "%Mandant%" == "" GOTO keinMandant
@SET MandantParam=-Mandant %Mandant%
@SET ProdatSrvIni=Administration\ProdatSRV_%Mandant%.ini
:keinMandant
@ECHO.

@REM Stop / Uninstall / Restart
@IF /i "%Operation%" == "o" GOTO Stop
@IF /i "%Operation%" == "u" GOTO Stop
@IF /i "%Operation%" == "r" GOTO Stop
@GOTO NoStop
:Stop
  @ECHO Service stoppen

  CD /D "%~dp0"
  CALL :ReadIni %ProdatSrvIni% DisplayName ServiceName
  @CALL :Trim ServiceName %ServiceName% 
  @IF     "%Mandant%" == ""   IF NOT DEFINED ServiceName   SET ServiceName=ProdatSRV
  @IF     "%Mandant%" == ""   IF "%ServiceName%" == ""     SET ServiceName=ProdatSRV
  @IF NOT "%Mandant%" == ""   IF NOT DEFINED ServiceName   SET ServiceName=ProdatSRV_%Mandant:-=_%
  @IF NOT "%Mandant%" == ""   IF "%ServiceName%" == ""     SET ServiceName=ProdatSRV_%Mandant:-=_%
  @ECHO Dienst-Name = "%ServiceName%"
  @ECHO.

  CD /D "%~dp0"
  NET STOP "%ServiceName%_Service"
  @ECHO.
  @ECHO ExitCode: %ERRORLEVEL%
  @IF %ERRORLEVEL% NEQ 0   PAUSE
  @ECHO.
:NoStop

@REM Uninstall
@IF /i "%Operation%" == "u" GOTO Uninstall
@GOTO NoUninstall
:Uninstall
  @ECHO Service deinstallieren
  
  CD /D "%~dp0"
  ProdatSRV.exe -uninstall %MandantParam%
  @ECHO.
  @ECHO ExitCode: %ERRORLEVEL%
  @IF %ERRORLEVEL% NEQ 0   PAUSE
  @ECHO.
:NoUninstall

@REM Restart
@IF /i "%Operation%" == "r" GOTO Restart
@GOTO NoRestart
:Restart
  @ECHO Pause (weiter mit beliebiger Taste)
  @PAUSE > NUL
  @ECHO.
:NoRestart

@REM Setup
@IF /i "%Operation%" == "s" GOTO Setup
@GOTO NoSetup
:Setup
  @ECHO Service einrichten
  
  CD /D "%~dp0"
  ProdatSRV.exe -install -setup %MandantParam%
  @ECHO.
  @ECHO ExitCode: %ERRORLEVEL%
  @IF %ERRORLEVEL% NEQ 0   PAUSE
  @ECHO.
:NoSetup


@REM Install
@IF /i "%Operation%" == "i" GOTO Install
@GOTO NoInstall
:Install
  @ECHO Service installieren

  CD /D "%~dp0"
  ProdatSRV.exe -install %MandantParam%
  @ECHO.
  @ECHO ExitCode: %ERRORLEVEL%
  @IF %ERRORLEVEL% NEQ 0   PAUSE
  @ECHO.
:NoInstall

@REM Start / Install / Restart
@IF /i "%Operation%" == "a" GOTO Start
@IF /i "%Operation%" == "i" GOTO Start
@IF /i "%Operation%" == "r" GOTO Start
@GOTO NoStart
:Start
  @ECHO Service starten

  CD /D "%~dp0"
  CALL :ReadIni %ProdatSrvIni% DisplayName ServiceName
  @CALL :Trim ServiceName %ServiceName% 
  @IF     "%Mandant%" == ""   IF NOT DEFINED ServiceName   SET ServiceName=ProdatSRV
  @IF     "%Mandant%" == ""   IF "%ServiceName%" == ""     SET ServiceName=ProdatSRV
  @IF NOT "%Mandant%" == ""   IF NOT DEFINED ServiceName   SET ServiceName=ProdatSRV_%Mandant:-=_%
  @IF NOT "%Mandant%" == ""   IF "%ServiceName%" == ""     SET ServiceName=ProdatSRV_%Mandant:-=_%
  @ECHO Dienst-Name = "%ServiceName%"
  @ECHO.

  CD /D "%~dp0"
  NET START "%ServiceName%_Service"
  @ECHO.
  @ECHO ExitCode: %ERRORLEVEL%
  @IF %ERRORLEVEL% NEQ 0   PAUSE
  @ECHO.
:NoStart

@REM Debug
@IF /i "%Operation%" == "d" GOTO Debug
@GOTO NoDebug
:Debug
  @ECHO Service debuggen -> Konsole kann geschlossen werden, wenn Dienst gestartet
  
  CD /D "%~dp0"
  ProdatSRV.exe -debug %MandantParam%
  @ECHO.
  @ECHO ExitCode: %ERRORLEVEL%
  @IF %ERRORLEVEL% NEQ 0   PAUSE
  @ECHO.
:NoDebug

@GOTO Wiederholen



:Trim
@REM @CALL :Trim VarName %VarName%
@SET %1=%2
@GOTO :EOF

:ReadIni
@REM @CALL :ReadIni FileName.ini ValueName VarName
@REM @ECHO ValueName = "%VarName%"
@FOR /f "tokens=2 delims==" %%a IN ('FIND "%~2=" %~1') DO @SET %~3=%%a
@GOTO :EOF
